/*
 * Decompiled with CFR 0.152.
 */
package JDescomApi;

import JDescomApi.JDescomHex;
import JDescomApi.JDescomMensaje;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class JDescomSendData {
    private String RespuestaXML;
    private String saldo;
    private String resultado;
    private String comentario;
    private String saldocontrol;
    private String emailnot;
    private int total = 0;
    private int totalenviados = 0;
    private int totalenviados_ok = 0;
    private int totalenviados_error = 0;
    private int control = 1;
    JDescomHex hex = null;
    private boolean remilist = false;
    private int MaxNumSMS = 0;
    private ArrayList lista_remitentes = null;
    private HashMap<String, JDescomMensaje> lista_mensajes = new HashMap();
    private Random rand;
    private String lastMensText;
    private boolean debug;

    JDescomSendData() {
        this.hex = new JDescomHex();
        this.rand = new Random();
    }

    void setDebug(boolean debug) {
        this.debug = debug;
    }

    String getSaldo() {
        return this.saldo;
    }

    String getComentario() {
        return this.comentario;
    }

    String getResultado() {
        return this.resultado;
    }

    String getSaldocontrol() {
        return this.saldocontrol;
    }

    String getEmailnot() {
        return this.emailnot;
    }

    int getTotal() {
        return this.total;
    }

    int getTotalenviados() {
        return this.totalenviados;
    }

    int getTotalenviados_ok() {
        return this.totalenviados_ok;
    }

    int getTotalenviados_error() {
        return this.totalenviados_error;
    }

    int getControl() {
        return this.control;
    }

    void setControl(int control) {
        this.control = control == 1 ? 1 : 0;
    }

    public void setMaxNumSMS(int MaxNum) {
        if (MaxNum < 0) {
            MaxNum = 0;
        }
        this.MaxNumSMS = MaxNum;
    }

    public int getMaxNumSMS() {
        return this.MaxNumSMS;
    }

    public void setRemilist(boolean remilist) {
        this.remilist = remilist;
    }

    int AddMensaje(String id, String numero, String texto, String remitente) {
        String[][] ntext = null;
        String text = "";
        String hcad = "";
        int nmens = 0;
        StringBuffer textoenviado = new StringBuffer();
        this.lastMensText = "";
        ntext = this.TextControl(texto);
        nmens = ntext.length;
        String dd = Integer.toHexString(this.rand.nextInt(255)).toUpperCase();
        if (dd.length() == 1) {
            dd = "0" + dd;
        }
        for (int k = 0; k < nmens; ++k) {
            JDescomMensaje mensaje = new JDescomMensaje();
            mensaje.setNumero(numero);
            mensaje.setRemitente(remitente);
            text = ntext[k][0];
            hcad = ntext[k][1].length() > 0 && nmens > 1 ? dd + ntext[k][1] : "";
            mensaje.setConcat(hcad);
            String sid = id + (this.total + 1);
            mensaje.setId(sid);
            mensaje.setTexto(text);
            this.lista_mensajes.put(sid, mensaje);
            textoenviado.append(text);
            ++this.total;
        }
        this.lastMensText = textoenviado.toString();
        return nmens;
    }

    String getLastMensText() {
        return this.lastMensText;
    }

    int AddMensajeWapPush(String id, String numero, String url, String remitente, String titulo) {
        String[][] ntext = null;
        String text = "";
        if (url.length() > 75) {
            return 0;
        }
        if (titulo.length() > 15) {
            titulo = titulo.substring(0, 14);
        }
        String wpid = this.getCadenaAlfanumAleatoria(10);
        JDescomMensaje mensaje = new JDescomMensaje();
        mensaje.setNumero(numero);
        mensaje.setRemitente(remitente);
        mensaje.setConcat("");
        String sid = id + (this.total + 1);
        mensaje.setId(sid);
        text = wpid + ":wp:" + url + ":wp:" + titulo;
        if (this.debug) {
            System.out.println("A\u00f1adiendo WapPush: " + text);
        }
        mensaje.setTexto(text);
        this.lista_mensajes.put(sid, mensaje);
        ++this.total;
        return 1;
    }

    void DeleteMensajes() {
        this.lista_mensajes.clear();
        this.total = 0;
        this.totalenviados = 0;
        this.totalenviados_ok = 0;
        this.totalenviados_error = 0;
    }

    String getRespuestaXML() {
        return this.RespuestaXML;
    }

    String getSendXMLMensajes() {
        String xmlMensajes = "";
        if (this.lista_mensajes.size() > 0) {
            xmlMensajes = "<Mensajes>";
            xmlMensajes = xmlMensajes + "<Total>" + this.total + "</Total>";
            xmlMensajes = xmlMensajes + "<Control>" + this.control + "</Control>";
            Collection<JDescomMensaje> c = this.lista_mensajes.values();
            for (JDescomMensaje msg : c) {
                xmlMensajes = xmlMensajes + "<Mensaje>";
                xmlMensajes = xmlMensajes + "<ID>" + msg.getId() + "</ID>";
                xmlMensajes = xmlMensajes + "<Destino>" + msg.getNumero() + "</Destino>";
                xmlMensajes = xmlMensajes + "<Texto>" + msg.getTextoHex() + "</Texto>";
                xmlMensajes = xmlMensajes + "<Concat>" + msg.getConcat() + "</Concat>";
                if (msg.getRemitente().length() > 0) {
                    xmlMensajes = xmlMensajes + "<Remitente>" + msg.getRemitenteHex() + "</Remitente>";
                }
                xmlMensajes = xmlMensajes + "</Mensaje>";
            }
            xmlMensajes = xmlMensajes + "</Mensajes>";
        }
        return xmlMensajes;
    }

    Iterator get_iterator_mensajes() {
        Collection<JDescomMensaje> c = this.lista_mensajes.values();
        Iterator<JDescomMensaje> it = c.iterator();
        return it;
    }

    Iterator get_iterator_remitentes() {
        Iterator it = null;
        if (this.lista_remitentes != null) {
            it = this.lista_remitentes.iterator();
        }
        return it;
    }

    boolean ParseRespuesta(String respuesta) {
        this.RespuestaXML = respuesta;
        if (this.debug) {
            System.out.println("RESPUESTA RECIBIDA: " + respuesta);
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(this.RespuestaXML)));
            doc.getDocumentElement().normalize();
            NodeList nodeLst = doc.getElementsByTagName("Autentificacion");
            for (int s = 0; s < nodeLst.getLength(); ++s) {
                Node fstNode = nodeLst.item(s);
                if (fstNode.getNodeType() != 1) continue;
                Element fstElmnt = (Element)fstNode;
                this.resultado = this.getElementoValor(fstElmnt, "Resultado");
                this.comentario = this.getElementoValor(fstElmnt, "Comentario");
                this.saldo = this.getElementoValor(fstElmnt, "Saldo");
                this.saldocontrol = this.getElementoValor(fstElmnt, "Saldocontrol");
                this.emailnot = this.getElementoValor(fstElmnt, "Emailnot");
            }
            NodeList nodeLstMens = doc.getElementsByTagName("Mensaje");
            for (int s = 0; s < nodeLstMens.getLength(); ++s) {
                Node fstNode = nodeLstMens.item(s);
                if (fstNode.getNodeType() != 1) continue;
                Element fstElmnt = (Element)fstNode;
                String id = this.getElementoValor(fstElmnt, "Id");
                String resultado = this.getElementoValor(fstElmnt, "Resultado");
                String comentario = this.getElementoValor(fstElmnt, "Comentario");
                this.updateResultadoMensaje(id, resultado, comentario);
                if (this.debug) {
                    System.out.println("Mensaje " + this.totalenviados + "  Id: " + id + " Resultado: " + resultado + " Comentario: " + comentario);
                }
                ++this.totalenviados;
                if (resultado.equals("1")) {
                    ++this.totalenviados_ok;
                    continue;
                }
                ++this.totalenviados_error;
            }
            if (this.remilist) {
                this.lista_remitentes = new ArrayList();
                NodeList nodeLstRemi = doc.getElementsByTagName("Remitente");
                for (int s = 0; s < nodeLstRemi.getLength(); ++s) {
                    Node fstNode = nodeLstRemi.item(s);
                    if (fstNode.getNodeType() != 1) continue;
                    Element fstElmnt = (Element)fstNode;
                    String tmp = this.getElementoValor(fstElmnt, "remitext");
                    String remitext = new String(JDescomHex.fromHexString(tmp));
                    String remicli = this.getElementoValor(fstElmnt, "remicli");
                    String remipred = this.getElementoValor(fstElmnt, "remipred");
                    if (remitext.length() <= 0) continue;
                    this.lista_remitentes.add(remitext);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void updateResultadoMensaje(String id, String resultado, String comentario) {
        JDescomMensaje mensaje = this.lista_mensajes.get(id);
        mensaje.setResultado(Integer.parseInt(resultado));
        mensaje.setComentario(comentario);
        this.lista_mensajes.put(id, mensaje);
    }

    private String getElementoValor(Element fstElmnt, String tagname) {
        String valor = "";
        try {
            NodeList fstNmElmntLst = fstElmnt.getElementsByTagName(tagname);
            Element fstNmElmnt = (Element)fstNmElmntLst.item(0);
            NodeList fstNm = fstNmElmnt.getChildNodes();
            valor = fstNm.item(0).getNodeValue();
        }
        catch (NullPointerException e) {
            valor = "";
        }
        return valor;
    }

    String getResultadoEnvio() {
        String tmp = "Resultado del envio: " + this.resultado + "\nComentario: " + this.comentario;
        tmp = tmp + "\nSaldo restante: " + this.saldo;
        tmp = tmp + "\nMensajes enviados: " + this.totalenviados;
        tmp = tmp + "\nMensajes enviados OK: " + this.totalenviados_ok;
        tmp = tmp + "\nMensajes enviados ERROR: " + this.totalenviados_error;
        return tmp;
    }

    private int mensDiv(int lt) {
        int nm = 1;
        if (lt > 160) {
            double dl = lt;
            double nsup = Math.ceil(dl / 153.0);
            nm = (int)nsup;
        }
        return nm;
    }

    private String[][] TextControl(String texto) {
        String text = null;
        String[][] ntext = null;
        int nmens = 1;
        DecimalFormat fmt = new DecimalFormat("00");
        text = texto.trim();
        if (text.length() > 160) {
            double tl = text.length();
            double nsup = Math.ceil(tl / 153.0);
            nmens = (int)nsup;
            if (nmens > this.MaxNumSMS && this.MaxNumSMS > 0) {
                nmens = this.MaxNumSMS;
            }
            ntext = new String[nmens][2];
            for (int j = 1; j <= nmens; ++j) {
                String hcad = fmt.format(nmens) + fmt.format(j);
                int i1 = (j - 1) * 153;
                int i2 = j * 153;
                if (i2 > text.length()) {
                    i2 = text.length();
                }
                ntext[j - 1][0] = text.substring(i1, i2);
                ntext[j - 1][1] = hcad;
            }
        } else {
            ntext = new String[1][2];
            ntext[0][0] = text;
            ntext[0][1] = "";
        }
        return ntext;
    }

    String getCadenaAlfanumAleatoria(int longitud) {
        String cadenaAleatoria = "";
        long milis = new GregorianCalendar().getTimeInMillis();
        Random r = new Random(milis);
        int i = 0;
        while (i < longitud) {
            char c = (char)r.nextInt(255);
            if ((c < '0' || c > '\t') && (c < 'A' || c > 'Z')) continue;
            cadenaAleatoria = cadenaAleatoria + c;
            ++i;
        }
        return cadenaAleatoria;
    }
}

