/*
 * Decompiled with CFR 0.152.
 */
package JDescomApi;

import JDescomApi.JDescomHex;
import JDescomApi.JDescomSendData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class JDescomSendSMS {
    static String AppName = "JDESCOM API 1.0";
    static String host = "www.descomsms.com";
    static String direccion = "/servlet/descomMessage.servlet.Servlet";
    static int puertoHTTP = 80;
    static int puertoHTTPS = 443;
    int puerto = puertoHTTP;
    String protocolo = "HTTP";
    boolean sendSSL = false;
    String Usuario;
    String Clave;
    String Remitente = "";
    String EmailNot = "";
    int Remilist = 0;
    boolean ssl = false;
    boolean xml = true;
    boolean debug = false;
    JDescomSendData JDS = null;
    JDescomHex hex = new JDescomHex();

    public JDescomSendSMS() {
        this.JDS = new JDescomSendData();
    }

    public void setSSL(boolean ssl) {
        this.sendSSL = ssl;
        if (ssl) {
            this.puerto = puertoHTTPS;
            this.protocolo = "https";
        } else {
            this.puerto = puertoHTTP;
            this.protocolo = "http";
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.JDS.setDebug(debug);
    }

    public void autenticacion(String usuario, String clave, String remitente, String emailnot) {
        this.Usuario = usuario;
        this.Clave = clave;
        this.Remitente = remitente;
        this.EmailNot = emailnot;
    }

    public int AddMensaje(String id, String numero, String texto, String remitente) {
        int add = this.JDS.AddMensaje(id, numero, texto, remitente);
        return add;
    }

    public String getLastMensText() {
        return this.JDS.getLastMensText();
    }

    public int AddMensajeWapPush(String id, String numero, String url, String remitente, String titulo) {
        int add = this.JDS.AddMensajeWapPush(id, numero, url, remitente, titulo);
        return add;
    }

    public void setModoEnvio(int control) {
        this.JDS.setControl(control);
    }

    public void DeleteMensajes() {
        this.JDS.DeleteMensajes();
    }

    public boolean SendSMS(String idenvio) {
        try {
            String xmlAutenticacion = this.CreateXMLAutenticacion(idenvio);
            String xmlMensajes = this.JDS.getSendXMLMensajes();
            String post_data = "xml=<TXEnvio>" + xmlAutenticacion + xmlMensajes + "</TXEnvio>";
            if (this.debug) {
                System.out.println("XML ENVIADO: " + post_data);
            }
            boolean resultadoEnvio = this.sendHTTP(post_data);
            return resultadoEnvio;
        }
        catch (NullPointerException e) {
            System.out.println("Error en datos");
            return false;
        }
    }

    public boolean SendGetSaldo() {
        try {
            String xmlAutenticacion = this.CreateXMLAutenticacion("");
            String post_data = "xml=<TXEnvio>" + xmlAutenticacion + "</TXEnvio>";
            if (this.debug) {
                System.out.println("XML ENVIADO: " + post_data);
            }
            boolean resultadoEnvio = this.sendHTTP(post_data);
            return resultadoEnvio;
        }
        catch (NullPointerException e) {
            System.out.println("Error en datos");
            return false;
        }
    }

    private boolean sendHTTP(String post_data) {
        try {
            String tmp;
            String direccion_post = direccion + "?" + post_data;
            URL dmurl = new URL(this.protocolo, host, this.puerto, direccion_post);
            URLConnection conn = dmurl.openConnection();
            conn.setDoOutput(true);
            if (this.sendSSL) {
                Authenticator au = new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication("usuario", "clave".toCharArray());
                    }
                };
                Authenticator.setDefault(au);
            }
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(post_data);
            wr.flush();
            BufferedReader buffer = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer respuesta = new StringBuffer();
            while ((tmp = buffer.readLine()) != null) {
                respuesta.append(tmp);
            }
            this.JDS.ParseRespuesta(respuesta.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getResultadoEnvio() {
        return this.JDS.getResultadoEnvio();
    }

    public int getTotalMensajes() {
        return this.JDS.getTotal();
    }

    public int getTotalMensajesEnviados() {
        return this.JDS.getTotalenviados();
    }

    public int getTotalMensajesEnviados_ok() {
        return this.JDS.getTotalenviados_ok();
    }

    public int getTotalMensajesEnviados_error() {
        return this.JDS.getTotalenviados_error();
    }

    public Iterator getMensajesIterator() {
        return this.JDS.get_iterator_mensajes();
    }

    public Iterator getRemitentesIterator() {
        return this.JDS.get_iterator_remitentes();
    }

    public String getResultado() {
        return this.JDS.getResultado();
    }

    public String getComentario() {
        return this.JDS.getComentario();
    }

    public String getSaldo() {
        return this.JDS.getSaldo();
    }

    public String getEmailnot() {
        return this.JDS.getEmailnot();
    }

    public String getSaldocontrol() {
        return this.JDS.getSaldocontrol();
    }

    public void setRemilist(int remilist) {
        this.Remilist = remilist;
        this.JDS.setRemilist(remilist == 1);
    }

    public void setMaxNumSMS(int maxnum) {
        this.JDS.setMaxNumSMS(maxnum);
    }

    public int getMaxNumSMS() {
        return this.JDS.getMaxNumSMS();
    }

    private String CreateXMLAutenticacion(String idenvio) {
        String xml = "";
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            String timeStamp = df.format(new Date());
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(this.Usuario.getBytes());
            md5.update(timeStamp.getBytes());
            md5.update(this.Clave.getBytes());
            byte[] b = md5.digest();
            String HashLogin = JDescomHex.toHexString(b);
            if (idenvio.length() > 25) {
                idenvio = idenvio.substring(0, 24);
            } else if (idenvio.length() == 0) {
                idenvio = timeStamp + this.JDS.getCadenaAlfanumAleatoria(11);
            }
            xml = "<Autentificacion>";
            xml = xml + "<Usuario>" + JDescomHex.toHexString(this.Usuario.getBytes()) + "</Usuario>";
            xml = xml + "<Remitente>" + JDescomHex.toHexString(this.Remitente.getBytes()) + "</Remitente>";
            xml = xml + "<App>" + JDescomHex.toHexString(AppName.getBytes()) + "</App>";
            xml = xml + "<Time>" + timeStamp + "</Time>";
            xml = xml + "<Hash>" + HashLogin + "</Hash>";
            xml = xml + "<Remilist>" + this.Remilist + "</Remilist>";
            xml = xml + "<idenvioExt>" + JDescomHex.toHexString(idenvio.getBytes()) + "</idenvioExt>";
            xml = xml + "<emailnot>" + JDescomHex.toHexString(this.EmailNot.getBytes()) + "</emailnot>";
            xml = xml + "</Autentificacion>";
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
        return xml;
    }
}

